<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <?php if (!empty($volunteers)): ?>
        <div class="row">
            <?php foreach ($volunteers as $volunteer): ?>
                <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                    <div class="card h-100 shadow-sm border-0 text-center volunteer-card">
                        <div class="card-body p-4">
                            <?php if (!empty($volunteer->profile_photo)): ?>
                                <img src="<?php echo base_url('uploads/volunteers/' . $volunteer->profile_photo); ?>" 
                                     class="rounded-circle mb-3" 
                                     alt="<?php echo htmlspecialchars($volunteer->full_name); ?>"
                                     style="width: 120px; height: 120px; object-fit: cover;">
                            <?php else: ?>
                                <div class="rounded-circle bg-primary d-inline-flex align-items-center justify-content-center mb-3" 
                                     style="width: 120px; height: 120px;">
                                    <span class="text-white" style="font-size: 3rem;">
                                        <?php echo strtoupper(substr($volunteer->full_name, 0, 1)); ?>
                                    </span>
                                </div>
                            <?php endif; ?>
                            
                            <h5 class="fw-bold mb-1"><?php echo htmlspecialchars($volunteer->full_name); ?></h5>
                            
                            <?php if (!empty($volunteer->occupation)): ?>
                                <p class="text-muted small mb-2"><?php echo htmlspecialchars($volunteer->occupation); ?></p>
                            <?php endif; ?>
                            
                            <?php if (!empty($volunteer->city)): ?>
                                <p class="text-muted small">
                                    <i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($volunteer->city); ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="text-center py-5">
            <i class="fas fa-users fa-4x text-muted mb-3"></i>
            <h4 class="text-muted">No Volunteers Yet</h4>
            <p class="text-muted">Be the first to join our volunteer team!</p>
        </div>
    <?php endif; ?>
    
    <div class="text-center mt-5">
        <h3 class="fw-bold mb-3">Want to Join Our Team?</h3>
        <p class="lead text-muted mb-4">Become a part of our volunteer community</p>
        <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-primary btn-lg">
            <i class="fas fa-hands-helping"></i> Apply Now
        </a>
    </div>
</div>

<style>
.volunteer-card {
    transition: transform 0.3s;
}
.volunteer-card:hover {
    transform: translateY(-5px);
}
</style>